% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grep_case.R
\name{grep_case}
\alias{grep_case}
\title{Switch-style recoding of values with string pattern matching}
\usage{
grep_case(
  x,
  ...,
  .preserve = FALSE,
  .default = NA,
  .exhaustive = FALSE,
  preserve = deprecated(),
  default = deprecated()
)
}
\arguments{
\item{x}{A vector}

\item{...}{<\code{\link[rlang:dyn-dots]{dynamic-dots}}> A sequence of two-sided
formulas or named arguments.
\itemize{
\item \strong{Formulas}: Elements of \code{x} that match the \link{regex} pattern on the
left hand side (LHS) of formulas will be replaced with the value in the
right hand side (RHS).
The LHS must evaluate to a character string.
The RHS must be of length one.
\code{NULL} inputs are ignored.
\item \strong{Named arguments}: named arguments are passed to \code{\link[=grepl]{grepl()}}.
}}

\item{.preserve, preserve}{If \code{TRUE}, unmatched elements of \code{x} will be returned
unmodified.
(The elements may have their type coerced to be compatible with
replacement values.)
If \code{FALSE}, unmatched elements of \code{x} will be replaced with \code{.default}.
Defaults to \code{FALSE}.}

\item{.default, default}{If \code{.preserve} is \code{FALSE}, a value to replace unmatched
elements of \code{x}.
Defaults to \code{NA}.}

\item{.exhaustive}{If \code{TRUE}, unmatched elements of \code{x} will result in
an error.
This can be useful to ensure you aren't accidentally forgetting to recode
any values.
Defaults to \code{FALSE}.

Note that if \code{.preserve} is \code{TRUE},
\code{.exhaustive} will never have any effect.}
}
\value{
A vector of the same length as \code{x}.
}
\description{
Switch-style recoding of values with string pattern matching
}
\examples{
words <- c("caterpillar", "dogwood", "catastrophe", "dogma")

grep_case(
  words,
  "cat" ~ "feline",
  "dog" ~ "canine"
)

caps_words <- c("caterpillar", "dogwood", "Catastrophe", "DOGMA")

grep_case(
  caps_words,
  "cat" ~ "feline",
  "dog" ~ "canine",
  ignore.case = TRUE
)

countries <- c(
  "France", "Ostdeutschland", "Westdeutschland", "Nederland",
  "Belgie (Vlaanderen)", "Belgique (Wallonie)", "Luxembourg", "Italia"
)

grep_case(
  countries,
  "Deutschland" ~ "Germany",
  "Belgi(qu)?e" ~ "Belgium",
  "Nederland"   ~ "Netherlands",
  "Italia"      ~ "Italy",
  .preserve     = TRUE,
  ignore.case   = TRUE
)
}
\seealso{
\code{\link[=grep_case_fct]{grep_case_fct()}} to return a factor and
\code{\link[=grep_case_list]{grep_case_list()}} to return a list

\code{\link[=fn_case]{fn_case()}}, to apply a function other than \code{grepl()} to each case

\code{\link[=switch_case]{switch_case()}} to recode values with exact matching

\code{\link[=in_case]{in_case()}}, a pipeable alternative to \code{\link[dplyr:case_when]{dplyr::case_when()}}

\code{\link[=switch]{switch()}} and \code{\link[=grepl]{grepl()}}, which inspired this function
}
