% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stats-utility.R
\name{geomSE}
\alias{geomSE}
\title{Compute geometric standard error of the mean.}
\usage{
geomSE(x, na.rm = FALSE)
}
\arguments{
\item{x}{Numeric vector.}

\item{na.rm}{Logical, should NA value(s) be removed (FALSE by default)?}
}
\value{
Numeric vector of length 1 with 
geometric standard error of the mean.
}
\description{
The geometric standard error of the mean is computed as:
\eqn{\exp(se(log(x)}, with:
\itemize{
\item{log: natural logarithm}
\item{\eqn{se}: standard error of the mean, as computed with \code{\link{se}}}
}
}
\examples{
# Geometric standard error of the mean of a sample from a log normal distribution:
geomSE(rlnorm(n = 1000, meanlog = 0, sdlog = 1))
}
\seealso{
Other stats utility functions: 
\code{\link{cv}()},
\code{\link{geomCV}()},
\code{\link{geomMean}()},
\code{\link{geomSD}()},
\code{\link{se}()}
}
\author{
Laure Cougnaud
}
\concept{stats utility functions}
