% Generated by roxygen2: do not edit by hand
% Please edit documentation in
%   R/flextable-convertSummaryStatisticsTableToFlextable.R
\name{formatCustomFlextable}
\alias{formatCustomFlextable}
\title{Format superscript/subscripts/bold cells in a flextable.
Superscript should be indicated as: '\code{a^{b}}',
subscript as '\code{a_{b}}' and bold as '\code{bold{a}}' in the
 the input summary table.}
\usage{
formatCustomFlextable(
  dataTable,
  ft,
  fontname = "Times",
  part = "body",
  fontsize = 8,
  iBase = 0,
  bold = FALSE
)
}
\arguments{
\item{dataTable}{data.frame with data used in table,
summary table for body or header data.frame for the header.}

\item{ft}{Corresponding \code{\link[flextable]{flextable}}.}

\item{fontname}{String with font name, 'Times' by default.}

\item{part}{string with part of the table to consider, 
see \code{\link[flextable]{compose}}.}

\item{fontsize}{Integer with font size, 8 by default.}

\item{iBase}{Integer with base row index (if different than 0).}

\item{bold}{Logical (FALSE by default) should the superscript/subscript 
be indicated in bold?}
}
\value{
\code{\link[flextable]{flextable}} with superscript/subscript.
}
\description{
Format superscript/subscripts/bold cells in a flextable.
Superscript should be indicated as: '\code{a^{b}}',
subscript as '\code{a_{b}}' and bold as '\code{bold{a}}' in the
 the input summary table.
}
\author{
Laure Cougnaud
}
\keyword{internal}
