% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pcaPlottly.R
\name{pcaPlottly}
\alias{pcaPlottly}
\title{pcaPlottly}
\usage{
pcaPlottly(logcounts, Sample, Group, title, palette, center, scale)
}
\arguments{
\item{logcounts}{Numeric matrix of log-CPM values (genes × samples), e.g., from edgeR::cpm.}

\item{Sample}{Character vector of sample names corresponding to the columns of  "logcounts ".}

\item{Group}{Factor or character vector denoting group/condition for each sample.}

\item{title}{Character. Title for the PCA plot.}

\item{palette}{Character. Name of a discrete color palette from the  "paletteer" package.}

\item{center}{Logical. If TRUE, center variables (genes) before PCA.}

\item{scale}{Logical. If TRUE, scale variables to unit variance before PCA.}
}
\value{
A Plotly object ( "plotly::ggplotly ") representing the interactive PCA scatterplot.
}
\description{
Create an interactive PCA scatter plot using Plotly from log-expression data.
}
\details{
This function performs Principal Component Analysis (PCA) on a log-count matrix
and generates an interactive plot of the first two principal components via
"plotly::ggplotly()".
\enumerate{
\item Transposes the  "logcounts " matrix so samples are rows.
\item Runs PCA with  "stats::prcomp() ", using centering and scaling as specified.
\item Computes percent variance explained by PC1 and PC2.
\item Builds a ggplot2 scatterplot and converts it to an interactive Plotly graph.
}
}
