% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CorrPlotHeatmaply.R
\name{CorrPlotHeatmaply}
\alias{CorrPlotHeatmaply}
\title{CorrPlotHeatmaply}
\usage{
CorrPlotHeatmaply(x, Color, type, cluster, scale, show_names, NumGenes, main)
}
\arguments{
\item{x}{Numeric matrix of log-CPM values (genes × samples), e.g., from "edgeR::cpm()".}

\item{Color}{Character. Name of a continuous palette from the "paletteer" package.}

\item{type}{Character. Correlation method passed to "Hmisc::rcorr()": "pearson", "spearman", or "kendall".}

\item{cluster}{Character or logical. Clustering option for dendrogram: "both", "row", "column", or "none".}

\item{scale}{Character. Scaling mode for the heatmap: "row", "column", or "none".}

\item{show_names}{Character. One of "both", "row", "column", or "none" to display row/column labels.}

\item{NumGenes}{Integer. Number of top-variance genes to include in the correlation.}

\item{main}{Character. The plot title}
}
\value{
A Plotly object (heatmaply) representing the interactive correlation heatmap.
}
\description{
Create an interactive correlation heatmap of top variable genes using Heatmaply.
}
\details{
This function selects the highest-variance genes from a log-CPM matrix, computes
pairwise correlation coefficients (and p-values) with "Hmisc::rcorr()", and renders
an interactive correlation heatmap via "heatmaply::heatmaply_cor()", using clustering
and scaling options derived from "pheatmap" call.
\enumerate{
\item Compute per-gene variance and select the top "NumGenes".
\item Subset the matrix and compute correlations (and p-values) via "Hmisc::rcorr()".
\item Generate a temporary static heatmap with "pheatmap" to extract dendrograms.
\item Render an interactive heatmap with "heatmaply::heatmaply_cor()", passing in color,
clustering, scaling, tick-label visibility, and point size based on -log10(p-value).
}
}
