% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getPlayerMatchSums.R
\name{getPlayerMatchsums}
\alias{getPlayerMatchsums}
\title{Return a dataframe that contains all player matchsums for a given match ID}
\usage{
getPlayerMatchsums(matches, token)
}
\arguments{
\item{matches}{'IMPECT' match IDs}

\item{token}{bearer token}
}
\value{
a dataframe containing the matchsums aggregated per player and position for the given match ID
}
\description{
Return a dataframe that contains all player matchsums for a given match ID
}
\examples{
# Toy example: this will error quickly (no API token)
try(player_match_sums <- getPlayerMatchsums(
  matches = c(0, 1),
  token = "invalid"
))

# Real usage: requires valid Bearer Token from `getAccessToken()`
\dontrun{
player_match_sums <- getPlayerMatchsums(
  matches = c(84248, 158150),
  token = "yourToken"
)
}
}
