% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getPlayerMatchScores.R
\name{getPlayerMatchScores}
\alias{getPlayerMatchScores}
\title{Return a dataframe that contains all player scores for a given match ID
and list of positions}
\usage{
getPlayerMatchScores(matches, positions, token)
}
\arguments{
\item{matches}{'IMPECT' match IDs}

\item{positions}{list of position names. Must be one of:   "GOALKEEPER",
"LEFT_WINGBACK_DEFENDER", "RIGHT_WINGBACK_DEFENDER", "CENTRAL_DEFENDER",
"DEFENSE_MIDFIELD", "CENTRAL_MIDFIELD", "ATTACKING_MIDFIELD", "LEFT_WINGER",
"RIGHT_WINGER", "CENTER_FORWARD"}

\item{token}{bearer token}
}
\value{
a dataframe containing the scores aggregated per player and
position for the given match ID and list of positions
}
\description{
Return a dataframe that contains all player scores for a given match ID
and list of positions
}
\examples{
# Toy example: this will error quickly (no API token)
try(player_match_scores <- getPlayerMatchScores(
  matches = c(0, 1),
  positions = c("INVALID_POSITION_1", "INVALID_POSITION_2"),
  token = "invalid"
))

# Real usage: requires valid Bearer Token from `getAccessToken()`
\dontrun{
player_match_scores <- getPlayerMatchScores(
  matches = c(84248, 158150),
  positions = c("CENTRAL_DEFENDER", "DEFENSE_MIDFIELD"),
  token = "yourToken"
)
}
}
