% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/weo_get.R
\name{weo_get}
\alias{weo_get}
\title{Get WEO Data}
\usage{
weo_get(
  entities = NULL,
  series = NULL,
  start_year = 1980L,
  end_year = NULL,
  year = NULL,
  release = NULL,
  quiet = TRUE
)
}
\arguments{
\item{entities}{An optional character vector of ISO3 country codes or country
group identifiers. See \link{weo_get_entities}.}

\item{series}{A optional character vector of series codes.
See \link{weo_get_series}.}

\item{start_year}{Minimum year to include. Defaults to 1980.}

\item{end_year}{Maximum year to include. Defaults to current year + 5 years.}

\item{year}{The year of a WEO publication (e.g., 2024). Defaults to latest
publication year.}

\item{release}{The release of a WEO publication ("Spring" or "Fall").
Defaults to latest publication release.}

\item{quiet}{A logical indicating whether to print download information.
Defaults to TRUE.}
}
\value{
A data frame with columns:
\describe{
\item{entity_id}{ISO3 country code or country group ID}
\item{entity_name}{Entity name}
\item{series_code}{WEO series code}
\item{series_name}{Series name}
\item{units}{Units of measurement}
\item{year}{Year}
\item{value}{Value}
}
}
\description{
Retrieve data from the IMF World Economic Outlook (WEO) database for specific
series, countries, and years.
}
\examples{
\dontshow{if (curl::has_internet()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
\donttest{
# Get GDP growth for selected countries
weo_get(
  entities = c("USA", "GBR", "DEU"),
  series = "NGDP_RPCH",
  start_year = 2015,
  end_year = 2020
)
}
\dontshow{\}) # examplesIf}
}
