% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/im.dvi.R
\name{im.dvi}
\alias{im.dvi}
\title{Compute the Difference Vegetation Index (DVI)}
\usage{
im.dvi(x, nir, red)
}
\arguments{
\item{x}{A `SpatRaster` object representing the input multispectral image.}

\item{nir}{An integer specifying the band index of the Near-Infrared (NIR) channel.}

\item{red}{An integer specifying the band index of the Red channel.}
}
\value{
A `SpatRaster` object containing the computed DVI values.
}
\description{
This function calculates the Difference Vegetation Index (DVI) from a multispectral raster image.
The DVI is computed as the difference between the Near-Infrared (NIR) and Red bands.
}
\details{
The Difference Vegetation Index (DVI) is a simple vegetation index used to assess plant health.
It is calculated as:
\deqn{DVI = NIR - Red}
Higher values indicate denser and healthier vegetation.
}
\examples{
library(terra)

# Load a multispectral raster image with 3 bands
r <- rast(system.file("ex/logo.tif", package = "terra"))

# Compute DVI using band 2 (proxy for NIR) and band 1 (Red)
dvi_raster <- im.dvi(r, nir = 2, red = 1)

plot(dvi_raster)


}
\references{
For more details on the DVI index, see:
\url{https://en.wikipedia.org/wiki/Vegetation_Index}
}
\seealso{
[im.classify()], [im.ridgeline()]
}
