% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/query.R
\name{tophits}
\alias{tophits}
\title{Obtain top hits from a GWAS dataset}
\usage{
tophits(
  id,
  pval = 5e-08,
  clump = 1,
  r2 = 0.001,
  kb = 10000,
  pop = "EUR",
  force_server = FALSE,
  opengwas_jwt = get_opengwas_jwt(),
  ...
)
}
\arguments{
\item{id}{Array of GWAS studies to query. See \code{\link{gwasinfo}} for available studies}

\item{pval}{use this p-value threshold. Default = \code{5e-8}}

\item{clump}{whether to clump (\code{1}) or not (\code{0}). Default = \code{1}}

\item{r2}{use this clumping r2 threshold. Default is very strict, \code{0.001}}

\item{kb}{use this clumping kb window. Default is very strict, \code{10000}}

\item{pop}{Super-population to use as reference panel. Default = \code{"EUR"}.
Options are \code{"EUR"}, \code{"SAS"}, \code{"EAS"}, \code{"AFR"}, \code{"AMR"}}

\item{force_server}{Logical. By default will return preclumped hits.
p-value threshold 5e-8, with r2 threshold 0.001 and kb threshold 10000,
using only SNPs with MAF > 0.01 in the European samples in 1000 genomes.
If force_server = \code{TRUE} then will recompute using server side LD reference panel.}

\item{opengwas_jwt}{Used to authenticate protected endpoints. Login to \url{https://api.opengwas.io} to obtain a jwt. Provide the jwt string here, or store in .Renviron under the keyname OPENGWAS_JWT.}

\item{...}{Unused, for extensibility}
}
\value{
Dataframe
}
\description{
By default performs clumping on the server side.
}
