% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ld_clump.R
\name{ld_clump_local}
\alias{ld_clump_local}
\title{Wrapper for clump function using local plink binary and ld reference dataset}
\usage{
ld_clump_local(dat, clump_kb, clump_r2, clump_p, bfile, plink_bin)
}
\arguments{
\item{dat}{Dataframe. Must have a variant name column (\code{variant}) and pval column called \code{pval}.
If \code{id} is present then clumping will be done per unique id.}

\item{clump_kb}{Clumping kb window. Default is very strict, \code{10000}}

\item{clump_r2}{Clumping r2 threshold. Default is very strict, \code{0.001}}

\item{clump_p}{Clumping sig level for index variants. Default = \code{1} (i.e. no threshold)}

\item{bfile}{If this is provided then will use the API. Default = \code{NULL}}

\item{plink_bin}{Specify path to plink binary. Default = \code{NULL}.
See \url{https://github.com/MRCIEU/genetics.binaRies} for convenient access to plink binaries}
}
\value{
data frame of clumped variants
}
\description{
Wrapper for clump function using local plink binary and ld reference dataset
}
