% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/haploDraw.R
\name{haploDraw}
\alias{haploDraw}
\title{Draw haplotypes onto a pedigree plot}
\usage{
haploDraw(
  x,
  ibd,
  chrom = NULL,
  ids = NULL,
  unit = "mb",
  L = NULL,
  pos = 1,
  cols = NULL,
  height = 4,
  width = 0.75,
  sep = 0.75,
  dist = 1,
  keep.par = FALSE,
  ...
)
}
\arguments{
\item{x}{A \code{ped} object.}

\item{ibd}{A \code{genomeSim} object, typically made by \code{\link[=ibdsim]{ibdsim()}}.}

\item{chrom}{A chromosome number, needed if \code{ibd} contains data from multiple
chromosomes.}

\item{ids}{A vector indicating for which pedigree members haplotypes should
be drawn. If NULL (default), all individuals in \code{ibd} are included.}

\item{unit}{Either "mb" (default) or "cm".}

\item{L}{A positive number: the chromosome length. By default derived from
\code{ibd}.}

\item{pos}{A vector recycled to \code{pedsize(x)}, indicating where haplotypes
should be drawn relative to the pedigree symbols: 0 = no haplotypes; 1 =
below; 2 = left; 3 = above; 4 = right. By default, all are placed below.}

\item{cols}{A colour vector corresponding to the alleles in \code{ibd}.}

\item{height}{The height of the haplotype rectangles in units of the pedigree
symbol height. Default: 4.}

\item{width}{The width of the haplotype rectangles in units of the pedigree
symbol width. Default: 0.75.}

\item{sep}{The separation between haplotypes within a pair, measured in
pedigree symbol widths.}

\item{dist}{The distance between pedigree symbols and the closest haplotype,
measured in pedigree symbol widths.}

\item{keep.par}{A logical, by default FALSE; passed on to \code{plot.ped()}.}

\item{...}{Further arguments passed on to \code{plot.ped()}, e.g. \code{margins} and
\code{cex}. See \code{?plotmethods} for a complete list.}
}
\value{
None.
}
\description{
Visualise the IBD pattern of a single chromosome, by drawing haplotypes onto
the pedigree.
}
\examples{

###############################
# Example 1: A family quartet #
###############################

x = nuclearPed(2)
map = uniformMap(M = 1)
s = ibdsim(x, map = map, seed = 4276)

haploDraw(x, s)

# Custom colours and placements
haploDraw(x, s, cols = c(3,7,2,4), pos = c(2,4,2,4))

# Standard plot options apply
haploDraw(x, s, margins = 3, cex = 1.5, title = "Full sibs")
 

###########################
# Example 2: Autozygosity #
###########################

x = halfCousinPed(0, child = TRUE)
map = uniformMap(M = 1)
s = ibdsim(x, map = map, skipRecomb = c(1,3), seed = 2)

# Only include relevant individuals (skip 1 and 3)
haploDraw(x, s, ids = c(2,4,5,6), pos = c(1,2,4,4))

###############################
# Example 3: X-chromosomal sims
###############################

x = nuclearPed(2, sex = 2:1)
s = ibdsim(x, N = 1, map = uniformMap(M = 1, chrom = "X"), seed = 123)

haploDraw(x, s)


}
