% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fitHMM.R
\name{fitHMM}
\alias{fitHMM}
\title{Fit a Hidden Markov Model to genotype data}
\usage{
fitHMM(
  data,
  ids = NULL,
  k1 = NULL,
  a = NULL,
  err = 0,
  method = "L-BFGS-B",
  thompson = FALSE,
  prepped = FALSE,
  verbose = FALSE,
  ...
)
}
\arguments{
\item{data}{Data frame with required columns \code{chrom}, \code{cm}, \code{a1} and \code{freq1}
(case insensitive).}

\item{ids}{Genotype columns (default: last 2 columns).}

\item{k1, a}{Numeric HMM parameters. Supplying a value fixes the parameter; if
NULL (default), the parameter is estimated.}

\item{err}{Error rate; a single number in \verb{[0,1]} (default: 0).}

\item{method}{A character string indicating the optimisation method to use.}

\item{thompson}{A logical indicating the optimisation method. (See Details.)}

\item{prepped}{A logical indicating if the input data has been internally
processed. Can be ignored by most users.}

\item{verbose}{A logical indicating whether to print information during the
optimisation.}

\item{...}{Additional arguments passed to the \code{control} parameter of
\code{\link[stats:optim]{stats::optim()}}.}
}
\value{
A list containing the fitted parameters \code{k1} and \code{a}, and some
additional information about the optimisation.
}
\description{
This function fits a continuous-time HMM to the provided genotype data, by
optimising the parameters \code{k1} (the probability of being in an IBD state) and
\code{a} (the transition rate) to maximise the total log-likelihood.
}
\details{
By default (\code{thompson = FALSE}) both parameters \code{k1} and \code{a} are optimised
together, using \code{\link[stats:optimize]{stats::optimise()}}.

If \code{thompson = TRUE}, then \code{k1} is estimated first, using the
maximum-likelihood approach for pairwise relatedness coefficients described
by Thompson (1975). (Note that, although this method was originally developed
for unlinked markers, it yields unbiased estimates also with linked markers.)
The estimation of \code{k1} is performed internally by calling
\code{\link[forrel:ibdEstimate]{forrel::ibdEstimate()}}. Subsequently, the parameter \code{a} is estimated
conditional on the \code{k1} value.
}
\examples{

fitHMM(cousinsDemo)

}
\seealso{
\code{\link[=totalLoglik]{totalLoglik()}}, \code{\link[forrel:ibdEstimate]{forrel::ibdEstimate()}}
}
