% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/findIBD.R
\name{findIBD}
\alias{findIBD}
\title{All-in-one workflow for finding IBD segments}
\usage{
findIBD(
  data,
  ids = NULL,
  k1 = NULL,
  a = NULL,
  err = 0,
  method = NULL,
  thompson = FALSE,
  verbose = TRUE
)
}
\arguments{
\item{data}{Data frame with required columns \code{chrom}, \code{cm}, \code{a1} and \code{freq1}
(case insensitive). Alternatively, a \code{ped} object, in which case the SNP
data is extracted internally.}

\item{ids}{Character vector indicating genotype columns of \code{data} (default:
last 2 columns).}

\item{k1, a}{HMM parameters passed on to \code{\link[=fitHMM]{fitHMM()}}. Supplying a value fixes
the parameter; if NULL (default), the parameter is estimated.}

\item{err}{Error rate; a single number in \verb{[0,1]} (default: 0).}

\item{method}{Optimisation method.}

\item{thompson}{A logical passed on to \code{\link[=fitHMM]{fitHMM()}}. Default: FALSE.}

\item{verbose}{A logical, by default TRUE.}
}
\value{
A list with the following elements:
\itemize{
\item \code{k1}: HMM parameter (estimated or provided)
\item \code{a}: HMM parameter (estimated or provided)
\item \code{segments}: Data frame with IBD segments
\item \code{posteriors}: Data frame with posterior IBD probabilities at each marker
}
}
\description{
This function conveniently wraps the key steps of the package. It first fits
a continuous-time HMM to the data (\code{\link[=fitHMM]{fitHMM()}}), then identifies IBD segments
(\code{\link[=findSegments]{findSegments()}}), and finally computes the marker-wise posterior IBD
probability at each marker locus (\code{\link[=ibdPosteriors]{ibdPosteriors()}}). The result can be
passed straight to \code{\link[=plotIBD]{plotIBD()}} for visualisation.
}
\examples{
ibd = findIBD(brothersX)
plotIBD(ibd)

}
\seealso{
\code{\link[=fitHMM]{fitHMM()}}, \code{\link[=findSegments]{findSegments()}}, \code{\link[=ibdPosteriors]{ibdPosteriors()}}, \code{\link[=plotIBD]{plotIBD()}}
}
