% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rescale.R
\name{rand_with_cor}
\alias{rand_with_cor}
\title{Create a Random Vector With Fixed Correlation With Another Vector}
\source{
This solution is based on an
\href{https://stats.stackexchange.com/a/313138/64220}{answer} by
\href{https://stats.stackexchange.com/users/919/whuber}{whuber}
on \href{https://stats.stackexchange.com}{Cross Validated}.
}
\usage{
rand_with_cor(y, rho, mu = mean(y), sigma = sd(y))
}
\arguments{
\item{y}{a numeric vector}

\item{rho}{numeric value between -1 and 1 giving the desired correlation.}

\item{mu}{numeric value giving the desired mean}

\item{sigma}{numeric value giving the desired standard
deviation}
}
\value{
a vector of the same length as \code{y} that has correlation \code{rho} with \code{y}.
}
\description{
\code{rand_with_cor()} creates a vector of random number that has
correlation \code{rho} with a given vector \code{y}.
Also mean and standard deviation of the random vector
can be fixed by the user. By default, they will be equal to the mean
and standard deviation of \code{y}, respectively.
}
\examples{
x <- runif(1000, 5, 8)

# create a random vector with positive correlation
y1 <- rand_with_cor(x, 0.8)
all.equal(cor(x, y1), 0.8)

# create a random vector with negative correlation
# and fixed mean and standard deviation
y2 <- rand_with_cor(x, -0.3, 2, 3)
all.equal(cor(x, y2), -0.3)
all.equal(mean(y2), 2)
all.equal(sd(y2), 3)

}
