% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ifcb_count_mat_annotations.R
\name{ifcb_count_mat_annotations}
\alias{ifcb_count_mat_annotations}
\title{Count IFCB Annotations from .mat Files}
\usage{
ifcb_count_mat_annotations(
  manual_files,
  class2use_file,
  skip_class = NULL,
  sum_level = "class",
  mat_recursive = FALSE,
  use_python = FALSE
)
}
\arguments{
\item{manual_files}{A character string specifying the path to the .mat files or a folder containing .mat files.}

\item{class2use_file}{A character string specifying the path to the file containing the class2use variable.}

\item{skip_class}{A numeric vector of class IDs or a character vector of class names to be excluded from the count. Default is NULL.}

\item{sum_level}{A character string specifying the level of summarization. Options: "sample", "roi" or "class" (default).}

\item{mat_recursive}{Logical. If TRUE, the function will search for MATLAB files recursively when \code{manual_files} is a folder. Default is FALSE.}

\item{use_python}{Logical. If \code{TRUE}, attempts to read the \code{.mat} file using a Python-based method. Default is \code{FALSE}.}
}
\value{
A data frame with the total count of images per class, roi or per sample.
}
\description{
This function processes \code{.mat} files, generated by the code in the \code{ifcb-analysis} repository (Sosik and Olson 2007),
to count and summarize the annotations for each class based on the class2use information provided in a file.
}
\details{
If \code{use_python = TRUE}, the function tries to read the \code{.mat} file using \code{ifcb_read_mat()}, which relies on \code{SciPy}.
This approach may be faster than the default approach using \code{R.matlab::readMat()}, especially for large \code{.mat} files.
To enable this functionality, ensure Python is properly configured with the required dependencies.
You can initialize the Python environment and install necessary packages using \code{ifcb_py_install()}.

If \code{use_python = FALSE} or if \code{SciPy} is not available, the function falls back to using \code{R.matlab::readMat()}.
}
\examples{
\dontrun{
# Count annotations excluding specific class IDs
result <- ifcb_count_mat_annotations("path/to/manual_folder",
                                     "path/to/class2use_file",
                                     skip_class = c(99, 100))
print(result)

# Count annotations excluding a specific class name
result <- ifcb_count_mat_annotations("path/to/manual_folder",
                                     "path/to/class2use_file",
                                     skip_class = "unclassified")
print(result)
}
}
\references{
Sosik, H. M. and Olson, R. J. (2007), Automated taxonomic classification of phytoplankton sampled with imaging-in-flow cytometry. Limnol. Oceanogr: Methods 5, 204–216.
}
