% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/integrandSurface.R
\name{integrandSurface}
\alias{integrandSurface}
\title{Integrand Surface(s) of Sign-Adjusted Quantile Indices \link{hyper_gam}}
\usage{
integrandSurface(
  ...,
  sign_adjusted = TRUE,
  newdata = data,
  proj_xy = TRUE,
  proj_xz = TRUE,
  proj_beta = FALSE,
  n = 501L,
  newid = seq_len(min(3L, .row_names_info(newdata, type = 2L))),
  qlim = range(X[is.finite(X)], newX[is.finite(newX)]),
  axis_col = c("dodgerblue", "deeppink", "darkolivegreen"),
  beta_col = "purple",
  surface_col = c("white", "lightgreen")
)
}
\arguments{
\item{...}{one or more \link{hyper_gam} models
based on \emph{a same data set}.}

\item{sign_adjusted}{\link[base]{logical} scalar}

\item{newdata}{see function \code{\link[=predict.hyper_gam]{predict.hyper_gam()}}.}

\item{proj_xy}{\link[base]{logical} scalar, whether to show
the projection of \eqn{\hat{S}\big(p, Q_i(p)\big)}
(see sections \strong{Details} and \strong{Value})
to the \eqn{(p,q)}-plain, default \code{TRUE}}

\item{proj_xz}{\link[base]{logical} scalar, whether to show
the projection of \eqn{\hat{S}\big(p, Q_i(p)\big)} to the \eqn{(p,s)}-plain, default \code{TRUE}}

\item{proj_beta}{\link[base]{logical} scalar, whether to show
\eqn{\hat{\beta}(p)} on the \eqn{(p,s)}-plain when applicable, default \code{TRUE}}

\item{n}{\link[base]{integer} scalar, fineness of visualization,
default \code{501L}. See parameter \code{n.grid} of function \link[mgcv]{vis.gam}.}

\item{newid}{\link[base]{integer} scalar or \link[base]{vector},
row indices of \code{newdata} to be visualized.
Default \code{1:2}, i.e., the first two test subjects.
Use \code{newid = NULL} to disable visualization of \code{newdata}.}

\item{qlim}{\link[base]{length}-2 \link[base]{double} \link[base]{vector},
range on \eqn{q}-axis. Default is the range of \eqn{X} and \eqn{X^{\text{new}}} combined.}

\item{axis_col}{\link[base]{length}-3 \link[base]{character} \link[base]{vector},
colors of the \eqn{(p,q,s)} axes}

\item{beta_col}{\link[base]{character} scalar, color
of \eqn{\hat{\beta(p)}}}

\item{surface_col}{\link[base]{length}-2 \link[base]{character} \link[base]{vector},
color of the integrand surface(s), for lowest and highest surface values}
}
\value{
Function \code{\link[=integrandSurface]{integrandSurface()}} returns a pretty \CRANpkg{htmlwidgets} created by \strong{R} package \CRANpkg{plotly}
to showcase the \link[graphics]{persp}ective plot of the
estimated sign-adjusted integrand surface \eqn{\hat{S}(p,q)}.

If a set of training/test subjects is selected (via parameter \code{newid}), then
\itemize{
\item {the estimated \strong{sign-adjusted line integrand curve} \eqn{\hat{S}\big(p, Q_i(p)\big)}
of subject \eqn{i}
is displayed on the surface \eqn{\hat{S}(p,q)};}
\item {the quantile curve \eqn{Q_i(p)}
is projected on the \eqn{(p,q)}-plain of the 3-dimensional \eqn{(p,q,s)} cube,
if \code{proj_xy=TRUE} (default);}
\item {the user-specified \eqn{\tilde{p}} is marked on the \eqn{(p,q)}-plain of the 3D cube,
if \code{proj_xy=TRUE} (default);}
\item {\eqn{\hat{S}\big(p, Q_i(p)\big)}
is projected on the \eqn{(p,s)}-plain of the 3-dimensional \eqn{(p,q,s)} cube,
if one and only one \link{hyper_gam} model is provided in in
put argument \code{...} and \code{proj_xz=TRUE} (default);}
\item {the estimated \emph{linear functional coefficient} \eqn{\hat{\beta}(p)} is shown on the \eqn{(p,s)}-plain of the 3D cube,
if one and only one \emph{linear} \link{hyper_gam} model is provided in input argument \code{...} and \code{proj_beta=TRUE} (default).}
}
}
\description{
An interactive \CRANpkg{htmlwidgets} of the
\link[graphics]{persp}ective plot for
\link{hyper_gam} model(s)
using package \CRANpkg{plotly}.
}
\note{
The maintainer is not aware of any functionality of projection of arbitrary curves in package \CRANpkg{plotly}.
Currently, the projection to \eqn{(p,q)}-plain is hard coded on \eqn{(p,q,s=\text{min}(s))}-plain.
}
\section{Integrand Surface}{


The estimated \strong{integrand surface} of quantile indices and non-linear quantile indices, defined on
\eqn{p\in[0,1]} and
\eqn{q\in\text{range}\big(Q_i(p)\big)} for all training subjects \eqn{i=1,\cdots,n},
is
\deqn{
\hat{S}_0(p,q) = 
\begin{cases}
\hat{\beta}(p)\cdot q & \text{for QI}\\
\hat{F}(p,q) & \text{for nlQI}
\end{cases}
}
}

\section{Sign-Adjustment}{


Ideally, we would wish that, \emph{in the training set}, the estimated linear and/or non-linear quantile indices
\deqn{
\widehat{\text{QI}}_i = \displaystyle\int_0^1 \hat{S}_0\big(p, Q_i(p)\big)dp
}
be \emph{positively correlated} with a more intuitive quantity, e.g., quantiles \eqn{Q_i(\tilde{p})} at a user-specified \eqn{\tilde{p}}, for the interpretation of downstream analysis,
Therefore, we define the sign-adjustment term
\deqn{
\hat{c} = \text{sign}\left(\text{corr}\left(Q_i(\tilde{p}), \widehat{\text{QI}}_i\right)\right),\quad i =1,\cdots,n
}
as the \link[base]{sign} of the \link[stats]{cor}relation between
the estimated quantile index \eqn{\widehat{\text{QI}}_i}
and the quantile \eqn{Q_i(\tilde{p})},
for training subjects \eqn{i=1,\cdots,n}.

The estimated \strong{sign-adjusted integrand surface} is
\eqn{\hat{S}(p,q) = \hat{c} \cdot \hat{S}_0(p,q)}.

The estimated \strong{sign-adjusted quantile indices}
\eqn{\int_0^1 \hat{S}\big(p, Q_i(p)\big)dp}
are positively correlated with subject-specific sample medians
(default \eqn{\tilde{p} = .5}) in the training set.
}

\keyword{internal}
