% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gmm.R
\name{drbounds}
\alias{drbounds}
\title{Upper bounds on rates of double reduction}
\usage{
drbounds(ploidy)
}
\arguments{
\item{ploidy}{The ploidy of the species. Should be even and at least 4.}
}
\value{
A vector of length \code{floor(ploidy/4)}. Element \code{i} is
the upper bound on the probability of \code{i} pairs of
identical-by-double-reduction alleles being in an individual.
}
\description{
Calculates the upper bounds of the double reduction parameters
according to the complete equation segregation model. See
Huang et. al. (2019) for details.
}
\examples{
drbounds(4)
drbounds(6)
drbounds(8)
drbounds(10)
drbounds(12)
drbounds(14)
drbounds(16)

}
\references{
\itemize{
\item{Huang, K., Wang, T., Dunn, D. W., Zhang, P., Cao, X., Liu, R., & Li, B. (2019). Genotypic frequencies at equilibrium for polysomic inheritance under double-reduction. \emph{G3: Genes, Genomes, Genetics}, 9(5), 1693-1706. \doi{10.1534/g3.119.400132}}
}
}
\author{
David Gerard
}
