% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/resp.R
\name{new_response}
\alias{new_response}
\title{Create a HTTP response}
\usage{
new_response(
  method,
  url,
  status_code,
  headers,
  body,
  timing = NULL,
  request = NULL,
  error_call = caller_env()
)
}
\arguments{
\item{method}{HTTP method used to retrieve the response.}

\item{url}{URL response came from; might not be the same as the URL in
the request if there were any redirects.}

\item{status_code}{HTTP status code. Must be a single integer.}

\item{headers}{HTTP headers. Can be supplied as a raw or character vector
which will be parsed using the standard rules, or a named list.}

\item{body}{The body of the response. Can be a raw vector, a \verb{<httr2_path>},
or a \link{StreamingBody}.}

\item{timing}{A named numeric vector giving the time taken by various
components.}

\item{request}{The \link{request} used to generate this response.}

\item{error_call}{Environment (on call stack) used in error messages.}
}
\value{
An HTTP response: an S3 list with class \code{httr2_response}.
}
\description{
This is the constructor function for the \code{httr2_response} S3 class. It is
useful primarily for mocking.
}
