% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_lit_oral_equiv.R
\name{get_wetmore_oral_equiv}
\alias{get_wetmore_oral_equiv}
\title{Get Literature Oral Equivalent Dose (deprecated).}
\usage{
get_wetmore_oral_equiv(
  conc,
  chem.name = NULL,
  chem.cas = NULL,
  suppress.messages = FALSE,
  which.quantile = 0.95,
  species = "Human",
  input.units = "uM",
  output.units = "mg",
  clearance.assay.conc = NULL,
  ...
)
}
\arguments{
\item{conc}{Bioactive in vitro concentration in units of specified
input.units, default of uM.}

\item{chem.name}{Either the chemical name or the CAS number must be
specified.}

\item{chem.cas}{Either the CAS number or the chemical name must be
specified.}

\item{suppress.messages}{Suppress output messages.}

\item{which.quantile}{Which quantile from the SimCYP Monte Carlo simulation
is requested. Can be a vector.  Papers include 0.05, 0.5, and 0.95 for
humans and 0.5 for rats.}

\item{species}{Species desired (either "Rat" or default "Human").}

\item{input.units}{Units of given concentration, default of uM but can also
be mg/L.}

\item{output.units}{Units of dose, default of 'mg' for mg/kg BW/ day or
'mol' for mol/ kg BW/ day.}

\item{clearance.assay.conc}{Concentration of chemical used in measureing
intrinsic clearance data, 1 or 10 uM.}

\item{...}{Additional parameters passed to get_lit_css.}
}
\value{
Equivalent dose in specified units, default of mg/kg BW/day.
}
\description{
This function is included for backward compatibility. It calls
\code{\link{get_lit_oral_equiv}} which
converts a chemical plasma concetration to an oral equivalent
dose using the values from the Wetmore et al. (2012) and (2013) publications
and other literature.
}
\examples{

table <- NULL
for(this.cas in sample(get_lit_cheminfo(),50)) table <- rbind(table,cbind(
as.data.frame(this.cas),as.data.frame(get_lit_oral_equiv(conc=1,chem.cas=this.cas))))




get_lit_oral_equiv(0.1,chem.cas="34256-82-1")

get_lit_oral_equiv(0.1,chem.cas="34256-82-1",which.quantile=c(0.05,0.5,0.95))

}
\references{
\insertRef{wetmore2012integration}{httk}

\insertRef{wetmore2013relative}{httk}

\insertRef{wetmore2015incorporating}{httk}
}
\author{
John Wambaugh
}
\keyword{Literature}
\keyword{Monte-Carlo}
