% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/method-mmatrix-apply.r
\name{apply}
\alias{apply}
\alias{apply,mmatrix-method}
\title{Apply functions over margins of a mmatrix}
\usage{
\S4method{apply}{mmatrix}(X, MARGIN, FUN, ..., simplify = TRUE)
}
\arguments{
\item{X}{a mmatrix}

\item{MARGIN}{an integer giving the subscript which the function will be applied over}

\item{FUN}{the function to be applied}

\item{...}{extra arguments for `FUN`}

\item{simplify}{a logical indicating whether the results should be simplified}
}
\value{
If 'simplify' is TRUE, a matrix (or a mmatrix) or a vector (or a mvector). 
If 'simplify' is FALSE, a list.
}
\description{
This method generalizes `base::apply` to mmatrix objects
}
\details{
If 'simplify' is TRUE the result will be a vector or a matrix, depending
on the size of the values returned by 'FUN'. If the size of this object is greater
than \code{houba(max.size)}, then it will be memory-mapped (i.e., either a mvector
or a mmatrix). If 'simplify' is FALSE, the result is a list.

The function extracts the rows or the columns of 'X' one by one, to a R
object, which is passed to 'FUN'.
}
\examples{
a <- matrix(1:6, 2, 3)
A <- as.mmatrix(a)
apply(A, 1, var)
apply(A, 2, var)

}
\seealso{
\code{\link[base:apply]{base:apply}}
}
