% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model-api.R
\name{hi_model_set_hessian}
\alias{hi_model_set_hessian}
\title{Set Hessian Matrix for Highs Model}
\usage{
hi_model_set_hessian(model, matrix)
}
\arguments{
\item{model}{an object of class \code{"highs_model"}.}

\item{matrix}{a matrix giving the Hessian matrix.
Allowed matrix classes are \code{"matrix"}, \code{"dgCMatrix"}, \code{"matrix.csc"},
and \code{"simple_triplet_matrix"}.}
}
\value{
\code{NULL}
}
\description{
This function sets the Hessian matrix for a given Highs model.
}
\examples{
model <- hi_new_model()
hessian_matrix <- matrix(c(1, 0, 0, 1), nrow = 2)
hi_model_set_hessian(model, hessian_matrix)

}
