% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tparams_transprobs.R
\name{summary.tparams_transprobs}
\alias{summary.tparams_transprobs}
\title{Summarize \code{tparams_transprobs} object}
\usage{
\method{summary}{tparams_transprobs}(object, probs = NULL, unflatten = FALSE, ...)
}
\arguments{
\item{object}{A \code{\link{tparams_transprobs}} object.}

\item{probs}{A numeric vector of probabilities with values in \verb{[0,1]} used
to compute quantiles. Computing quantiles can be slow when \code{object} is large,
so the default is \code{NULL}, meaning that no quantiles are computed.}

\item{unflatten}{If \code{FALSE}, then each column containing a summary statistic
is a vector and the generated table contains one row
(for each set of ID variables) for each possible transition; if
\code{TRUE}, then each column stores a list of \code{matrix} objects containing
transition probability matrices formed by "unflattening" the one-dimensional
vectors. See "Value" below for additional details.}

\item{...}{Additional arguments affecting the summary. Currently unused.}
}
\value{
If \code{unflatten = "FALSE"} (the default), then a \code{\link[data.table:data.table]{data.table::data.table}}
is returned with columns for (i) the health state that is being transitioned
from (\code{from}), (ii) the health state that is being transitioned to (\code{to})
(iii) the mean of each parameter across parameter samples (\code{mean}),
(iv) the standard deviation of the parameter samples (\code{sd}), and
(v) quantiles of the parameter samples corresponding to the \code{probs} argument.

If, on the other hand, \code{unflatten = "TRUE"}, then the parameters are unflattened
to form transition probability matrices; that is, the \code{mean}, \code{sd}, and
quantile columns are (lists of) matrices.

In both cases, the ID variables are also returned as columns.
}
\description{
The \code{summary()} method summarizes a \code{\link{tparams_transprobs}} object containing
predicted transition probabilities; summary statistics are computed for each
possible transition by the relevant ID variables.
}
\seealso{
See \code{\link{tparams_transprobs}} for an example use of the summary method.
}
