% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geometry.R
\name{pointsToSegments}
\alias{pointsToSegments}
\title{Construct a data frame of segments from a data frame of points}
\usage{
pointsToSegments(pointsDF, joinEnds = TRUE)
}
\arguments{
\item{pointsDF}{A data frame with the x and y coordinates of the points.
Each point must appear only once.}

\item{joinEnds}{Whether to join the last point with the first one.}
}
\value{
A data frame of segments represented using four columns
(\code{x}, \code{y}, \code{xEnd}, \code{yEnd}).
}
\description{
This function constructs a data frame of segments from a data frame of
points.
}
\examples{
pointsDF <- data.frame(x = c(1, 2, 4, 7, 10,
12, 13, 15, 16),
y = c(1, 1, 2, 3, 3, 2, 1, 2, 1))

hullIndices <- grDevices::chull(pointsDF[, 1], pointsDF[, 2])
hull <- convexHull(pointsDF, hullIndices)
pointsToSegments(hull)

}
