% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pulse_optimize.R
\name{pulse_smooth}
\alias{pulse_smooth}
\title{Smooth PULSE data}
\usage{
pulse_smooth(split_window, bandwidth = 0.2)
}
\arguments{
\item{split_window}{one element of the \code{pulse_data_split} list() (which is the output from \code{\link[=pulse_split]{pulse_split()}}).}

\item{bandwidth}{numeric, defaults to \code{0.2}; the bandwidth for the Kernel Regression Smoother. If equal to \code{0} (zero) no smoothing is applied. Normally kept low (\code{0.1 - 0.3}) so that only very high frequency noise is removed, but can be pushed up all the way to \code{1} or above (especially when the heartbeat rate is expected to be slow, as is typical of oysters, but double check the resulting data). Type \code{?ksmooth} for additional info.}
}
\value{
The same PULSE tibble supplied in \code{split_window}, but now with data for all channels transformed by smoothing.
}
\description{
The performance of the algorithm employed in the downstream function \code{pulse_heart()} for the detection of heart beat wave crests depends significantly on the data not being too noisy. \code{pulse_smooth()} reshapes the data and improves the likelihood of \code{pulse_heart()} successfully estimating the inherent heartbeat rates.
\itemize{
\item \code{SMOOTHING} should be experimented with when \code{pulse_heart()} produces too many heartbeat rate estimates that are clearly incorrect. In such situations, \code{pulse_smooth()} applies a smoothing filter (normal Kernel Regression Smoother) to the data to smooth out high-frequency noise and render a more sinusoidal wave, which is easier to handle. Unlike \code{interpolation_freq}, users should exercise caution when setting \code{bandwidth} and generally opt for lower values, as there's a threshold to bandwidth values above which the resulting smoothed pulse data becomes completely unrelated to the original data, and the subsequent heartbeat rates computed with \code{pulse_heart()} may be wrong. Always double-check the data after applying a stronger smoothing. Nonetheless, note that if applied with the default \code{bandwidth}, smoothing incurs no penalty and hardly changes the data - so it isn't worth going out of the way to not apply smoothing.
}
}
\examples{
## Begin prepare data ----
pulse_data_sub <- pulse_data
pulse_data_sub$data <- pulse_data_sub$data[,1:5]
pulse_data_split <- pulse_split(pulse_data_sub)
## End prepare data ----

# Smooth data slightly ('bandwidth' = 0.2)
pulse_smooth(pulse_data_split$data[[1]], 0.2)
}
\seealso{
\itemize{
\item \code{\link[=ksmooth]{ksmooth()}} is used for the kernel smoothing of PULSE data
\item \code{\link[=pulse_optimize]{pulse_optimize()}} is a wrapper function that executes \code{\link[=pulse_interpolate]{pulse_interpolate()}} and \code{pulse_smooth} sequentially
\item \code{\link[=pulse_read]{pulse_read()}}, \code{\link[=pulse_split]{pulse_split()}}, \code{\link[=pulse_heart]{pulse_heart()}}, \code{\link[=pulse_doublecheck]{pulse_doublecheck()}} and \code{\link[=pulse_choose_keep]{pulse_choose_keep()}} are the other functions needed for the complete PULSE processing workflow
\item \code{\link[=PULSE]{PULSE()}} is a wrapper function that executes all the steps needed to process PULSE data at once
}
}
