% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-documentation.R
\name{acceldata2_list}
\alias{acceldata2_list}
\title{Accelerometer Data Example 2}
\format{
A list with 4 components:
\describe{
  \item{PA}{An integer matrix with 1,288 rows (daily profiles) and 1,440 columns
  (minute-by-minute accelerometer counts).}
  \item{label}{A data frame with 1,288 observations and 3 variables:
  \describe{
    \item{id}{Integer identifier of the profile}
    \item{day}{Integer indicating the day label}
    \item{personid2}{Integer providing an alternative identifier of the individual}
  }}
  \item{flag}{A numeric matrix with the same dimensions as \code{PA}, containing quality
  indicators (e.g., 0 = valid, 1 = flagged).}
  \item{demo}{A data frame with 184 observations and 5 variables:
  \describe{
    \item{personid}{Integer identifying the participant}
    \item{age}{Integer indicating age}
    \item{sex}{Factor with 2 levels indicating sex}
    \item{bmi}{Numeric variable with body mass index}
    \item{race}{Factor with 2 levels indicating race}
  }}
}
}
\source{
Data taken from the accelmissing package version 2.2.
}
\usage{
data(acceldata2_list)
}
\description{
Data example from the 2003-2004 National Health and Nutrition Examination Survey (NHANES)
dataset. This example includes 184 individuals, giving 1,288 daily profiles. It only includes
valid subjects with at least three complete days, obtained as a subset of \code{acceldata_list}
using the function \code{valid.subjects()}.
}
\details{
The dataset name has been kept as 'acceldata2_list' to avoid confusion with other datasets
in the R ecosystem. This naming convention helps distinguish this dataset as part of the
healthmotionR package and assists users in identifying its specific characteristics.
The suffix 'list' indicates that the dataset is stored as a list containing multiple components.
The original content has not been modified in any way.
}
