% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.R
\name{predict.mixturecure}
\alias{predict.mixturecure}
\title{Predicted probabilities for susceptibles, linear predictor for latency, and
risk class for latency for mixture cure fit}
\usage{
\method{predict}{mixturecure}(object, newdata, model_select = "AIC", ...)
}
\arguments{
\item{object}{a \code{mixturecure} object resulting from \code{curegmifs},
\code{cureem}, \code{cv_curegmifs}, or \code{cv_cureem}.}

\item{newdata}{an optional data.frame that minimally includes the incidence
and/or latency variables to use for predicting the response. If omitted, the
training data are used.}

\item{model_select}{either a case-sensitive parameter for models fit using
\code{curegmifs} or \code{cureem} or any numeric step along the solution path
can be selected. The default is \code{model_select = "AIC"} which calculates
the predicted values using the coefficients from the model achieving the
minimum AIC. The complete list of options are:
\itemize{
\item \code{"AIC"} for the minimum AIC (default).
\item \code{"mAIC"} for the minimum modified AIC.
\item \code{"cAIC"} for the minimum corrected AIC.
\item \code{"BIC"}, for the minimum BIC.
\item \code{"mBIC"} for the minimum modified BIC.
\item \code{"EBIC"} for the minimum extended BIC.
\item \code{"logLik"} for the step that maximizes the
log-likelihood.
\item \code{n} where n is any numeric value from the
solution path.
}
This option has no effect for objects fit using \code{cv_curegmifs} or
\code{cv_cureem}.}

\item{...}{other arguments}
}
\value{
\item{p_uncured}{ a vector of probabilities from the incidence
portion of the fitted model representing the P(uncured).}

\item{linear_latency}{ a vector for the linear predictor from the
latency portion of the model.}

\item{latency_risk}{ a dichotomous class representing low (below the
median) versus high risk for the latency portion of the model.}
}
\description{
This function returns a list that includes the predicted probabilities for
susceptibles as well as the linear predictor for the latency distribution
and a dichotomous risk for latency for a \code{curegmifs}, \code{cureem},
\code{cv_curegmifs} or \code{cv_cureem} fitted object.
}
\examples{
library(survival)
withr::local_seed(1234)
temp <- generate_cure_data(n = 100, j = 10, n_true = 10, a = 1.8)
training <- temp$training
fit <- curegmifs(Surv(Time, Censor) ~ .,
  data = training, x_latency = training,
  model = "weibull", thresh = 1e-4, maxit = 2000,
  epsilon = 0.01, verbose = FALSE
)
predict_train <- predict(fit)
names(predict_train)
testing <- temp$testing
predict_test <- predict(fit, newdata = testing)
}
\seealso{
\code{\link{curegmifs}}, \code{\link{cureem}},
\code{\link{coef.mixturecure}}, \code{\link{summary.mixturecure}},
\code{\link{plot.mixturecure}}
}
\keyword{methods}
