% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_sim_desc.R
\docType{data}
\name{data_betalogitnorm}
\alias{data_betalogitnorm}
\title{Simulation Data for Beta Logit Normal Model}
\format{
A data frame with 100 rows and 9 variables:
\describe{
\item{y}{Response variable - The proportion of simulation results, has a value between 0 and 1, follows a Beta distribution.}
\item{theta}{True latent mean parameter on the logit scale, representing the underlying probability of success in each area.}
\item{x1, x2, x3}{Predictors Variables}
\item{n}{The number of sample units for each region used in the survey}
\item{deff}{Design Effect}
\item{group}{Area ID (1–100) Random effects formula specifying the grouping structure in the data. }
\item{sre}{An optional grouping factor mapping observations to spatial locations.}
}
}
\source{
Simulated data based on a Beta-Logit-Normal model.
}
\usage{
data_betalogitnorm
}
\description{
The \code{data_betalogitnorm} is a simulation data created specifically to demonstrate the implementation of
\emph{Hierarchical Bayesian Small Area Estimation} (HB SAE) with Beta distribution.
This data is suitable for testing Beta regression models with a hierarchical structure
between areas. This data is also equipped with variables that apply spatial effects.
}
\examples{
data(data_betalogitnorm)
head(data_betalogitnorm)
}
\keyword{datasets}
