% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{print.ipw_haldensify}
\alias{print.ipw_haldensify}
\title{Print: IPW Estimates of the Causal Effects of Stochatic Shift Interventions}
\usage{
\method{print}{ipw_haldensify}(x, ..., ci_level = 0.95)
}
\arguments{
\item{x}{An object of class \code{ipw_haldensify}.}

\item{...}{Other options (not currently used).}

\item{ci_level}{A \code{numeric} indicating the level of the confidence
interval to be computed.}
}
\value{
None. Called for the side effect of printing an informative summary
 of slots of objects of class \code{ipw_haldensify}.
}
\description{
Print: IPW Estimates of the Causal Effects of Stochatic Shift Interventions
}
\details{
The \code{print} method for objects of class \code{ipw_haldensify}
}
\examples{
# simulate data
set.seed(11249)
n_obs <- 50
W1 <- rbinom(n_obs, 1, 0.6)
W2 <- rbinom(n_obs, 1, 0.2)
A <- rnorm(n_obs, (2 * W1 - W2 - W1 * W2), 2)
Y <- rbinom(n_obs, 1, plogis(3 * A + W1 + W2 - W1 * W2))

# fit the IPW estimator
est_ipw_shift <- ipw_shift(
  W = cbind(W1, W2), A = A, Y = Y,
  delta = 0.5, n_bins = 3L, cv_folds = 3L,
  lambda_seq = exp(seq(-1, -10, length = 100L)),
  # arguments passed to hal9001::fit_hal()
  max_degree = 1,
  # ...continue arguments for IPW
  selector_type = "gcv"
)
print(est_ipw_shift)
}
