% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lca_subset.R
\name{lca_adj}
\alias{lca_adj}
\title{Person Level Adjustment}
\usage{
lca_adj(pre = NULL, pst = NULL)
}
\arguments{
\item{pre}{pre data frame}

\item{pst}{pst data frame}
}
\value{
list of pre and post adjusted responses
}
\description{
Adjusts observed 1s based on item level parameters of the LCA model. Currently only takes data with Don't Know. And treats don't know responses as true confessions on ignorance.
If NAs are observed in the data, they are treating as acknowledgments of ignorance.
}
\examples{
pre_test_var <- data.frame(pre = c(1, 0, 0, 1, "d", "d", 0, 1, NA))
pst_test_var <- data.frame(pst = c(1, NA, 1, "d", 1, 0, 1, 1, "d"))
lca_adj(pre_test_var, pst_test_var)
}
