% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sort_filter_p.R
\name{sort_filter_p}
\alias{sort_filter_p}
\alias{sort_p}
\alias{filter_p}
\title{Sort/filter by p-values}
\usage{
sort_p(x, q = FALSE)

filter_p(x, q = FALSE, t = 0.05)
}
\arguments{
\item{x}{(\code{gtsummary})\cr
An object created using gtsummary functions}

\item{q}{(scalar \code{logical})\cr
When \code{TRUE} will check the q-value column rather
than the p-value. Default is \code{FALSE}.}

\item{t}{(scalar \code{numeric})\cr
Threshold below which values will be retained. Default is 0.05.}
}
\description{
Sort/filter by p-values
}
\examples{
# Example 1 ----------------------------------
trial \%>\%
  select(age, grade, response, trt) \%>\%
  tbl_summary(by = trt) \%>\%
  add_p() \%>\%
  filter_p(t = 0.8) \%>\%
  sort_p()

# Example 2 ----------------------------------
glm(response ~ trt + grade, trial, family = binomial(link = "logit")) \%>\%
  tbl_regression(exponentiate = TRUE) \%>\%
  sort_p()
}
\author{
Karissa Whiting, Daniel D. Sjoberg
}
