% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inline_text.tbl_continuous.R
\name{inline_text.tbl_continuous}
\alias{inline_text.tbl_continuous}
\title{Report statistics from summary tables inline}
\usage{
\method{inline_text}{tbl_continuous}(
  x,
  variable,
  column = NULL,
  level = NULL,
  pattern = NULL,
  pvalue_fun = label_style_pvalue(prepend_p = TRUE),
  ...
)
}
\arguments{
\item{x}{(\code{tbl_continuous})\cr
Object created from  \code{tbl_continuous()}}

\item{variable}{(\code{\link[dplyr:dplyr_tidy_select]{tidy-select}})\cr
A single variable name of statistic to present}

\item{column}{(\code{\link[dplyr:dplyr_tidy_select]{tidy-select}})\cr
Column name to return from \code{x$table_body}.
Can also pass the level of a by variable.}

\item{level}{(\code{string})\cr
Level of the variable to display for categorical variables.
Default is \code{NULL}}

\item{pattern}{(\code{string})\cr
String indicating the statistics to return.
Uses \code{\link[glue:glue]{glue::glue()}} formatting. Default is \code{NULL}}

\item{pvalue_fun}{(\code{function})\cr
Function to round and format p-values. Default is \code{label_style_pvalue()}.
The function must have a numeric vector input, and return a string that is
the rounded/formatted p-value (e.g. \code{pvalue_fun = label_style_pvalue(digits = 2)}).}

\item{...}{These dots are for future extensions and must be empty.}
}
\value{
A string reporting results from a gtsummary table
}
\description{
Extracts and returns statistics from a \code{tbl_continuous()} object for
inline reporting in an R markdown document. Detailed examples in the
\href{https://www.danieldsjoberg.com/gtsummary/articles/inline_text.html}{inline_text vignette}
}
\examples{
t1 <- trial |>
  tbl_summary(by = trt, include = grade) |>
  add_p()

inline_text(t1, variable = grade, level = "I", column = "Drug A", pattern = "{n}/{N} ({p}\%)")
inline_text(t1, variable = grade, column = "p.value")
}
\author{
Daniel D. Sjoberg
}
