% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/select_helpers.R
\name{.list2tb}
\alias{.list2tb}
\title{Convert Named List to Table Body}
\usage{
.list2tb(x, colname = caller_arg(x))
}
\arguments{
\item{x}{named list}

\item{colname}{string of column name to assign. Default is \code{caller_arg(x)}}
}
\value{
\code{.$table_body} data frame
}
\description{
Many arguments in 'gtsummary' accept named lists. This function converts
a named list to the \code{.$table_body} format expected in \code{scope_table_body()}
}
\examples{
type <- list(age = "continuous", response = "dichotomous")
gtsummary:::.list2tb(type, "var_type")
}
\keyword{internal}
