% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metrics-generics.R
\name{max_prob}
\alias{max_prob}
\alias{max_prob.default}
\alias{max_prob.matrix}
\alias{max_prob.FitLandDF}
\title{Maximum Probability Metric for a GLCM}
\usage{
max_prob(x, ...)

\method{max_prob}{default}(x, ...)

\method{max_prob}{matrix}(x, ...)

\method{max_prob}{FitLandDF}(x, nlevels, ...)
}
\arguments{
\item{x}{gray-level co-occurrence matrix}

\item{...}{additional parameters}

\item{nlevels}{desired number of discrete gray levels}
}
\value{
double
}
\description{
Calculate the maximum probability feature or metric for a gray-level co-occurrence
matrix. For definition and application, see Lofstedt et al. (2019)
\doi{10.1371/journal.pone.0212110}.
}
\examples{
## calculate maximum probability of arbitrary GLCM
# define arbitrary GLCM
x <- matrix(1:16, nrow = 4)

# normalize
n_x <- normalize_glcm(x)

# calculate maximum probability
max_prob(n_x)

## calculate maximum probability of arbitrary fitness landscape
# create fitness landscape using FitLandDF object
vals <- runif(64)
vals <- array(vals, dim = rep(4, 3))
my_landscape <- fitscape::FitLandDF(vals)

# calculate maximum probability of fitness landscape, assuming 2 discrete gray levels
max_prob(my_landscape, nlevels = 2)

## confirm value of maximum probability for fitness landscape
# extract normalized GLCM from fitness landscape
my_glcm <- get_comatrix(my_landscape, discrete = equal_discrete(2))

# calculate maximum probability of extracted GLCM
max_prob(my_glcm)  # should match value of above max_prob function call
}
