% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metrics-generics.R
\name{inv_diff}
\alias{inv_diff}
\alias{inv_diff.default}
\alias{inv_diff.matrix}
\alias{inv_diff.FitLandDF}
\title{Inverse Difference Metric for a GLCM}
\usage{
inv_diff(x, ...)

\method{inv_diff}{default}(x, ...)

\method{inv_diff}{matrix}(x, ...)

\method{inv_diff}{FitLandDF}(x, nlevels, ...)
}
\arguments{
\item{x}{gray-level co-occurrence matrix}

\item{...}{additional parameters}

\item{nlevels}{desired number of discrete gray levels}
}
\value{
double
}
\description{
Calculate the inverse difference feature or metric for a gray-level co-occurrence
matrix. For definition and application, see Lofstedt et al. (2019)
\doi{10.1371/journal.pone.0212110}.
}
\examples{
## calculate inverse difference of arbitrary GLCM
# define arbitrary GLCM
x <- matrix(1:16, nrow = 4)

# normalize
n_x <- normalize_glcm(x)

# calculate inverse difference
inv_diff(n_x)

## calculate inverse difference of arbitrary fitness landscape
# create fitness landscape using FitLandDF object
vals <- runif(64)
vals <- array(vals, dim = rep(4, 3))
my_landscape <- fitscape::FitLandDF(vals)

# calculate inverse difference of fitness landscape, assuming 2 discrete gray levels
inv_diff(my_landscape, nlevels = 2)

## confirm value of inverse difference for fitness landscape
# extract normalized GLCM from fitness landscape
my_glcm <- get_comatrix(my_landscape, discrete = equal_discrete(2))

# calculate inverse difference of extracted GLCM
inv_diff(my_glcm)  # should match value of above inv_diff function call
}
