% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metrics-generics.R
\name{entropy}
\alias{entropy}
\alias{entropy.default}
\alias{entropy.matrix}
\alias{entropy.FitLandDF}
\title{Entropy Metric for a GLCM}
\usage{
entropy(x, ...)

\method{entropy}{default}(x, ...)

\method{entropy}{matrix}(x, ...)

\method{entropy}{FitLandDF}(x, nlevels, ...)
}
\arguments{
\item{x}{gray-level co-occurrence matrix}

\item{...}{additional parameters}

\item{nlevels}{desired number of discrete gray levels}
}
\value{
double
}
\description{
Calculate the entropy feature or metric for a gray-level co-occurrence
matrix. For definition and application, see Lofstedt et al. (2019)
\doi{10.1371/journal.pone.0212110}.
}
\examples{
## calculate entropy of arbitrary GLCM
# define arbitrary GLCM
x <- matrix(1:16, nrow = 4)

# normalize
n_x <- normalize_glcm(x)

# calculate entropy
entropy(n_x)

## calculate entropy of arbitrary fitness landscape
# create fitness landscape using FitLandDF object
vals <- runif(64)
vals <- array(vals, dim = rep(4, 3))
my_landscape <- fitscape::FitLandDF(vals)

# calculate entropy of fitness landscape, assuming 2 discrete gray levels
entropy(my_landscape, nlevels = 2)

## confirm value of entropy for fitness landscape
# extract normalized GLCM from fitness landscape
my_glcm <- get_comatrix(my_landscape, discrete = equal_discrete(2))

# calculate entropy of extracted GLCM
entropy(my_glcm)  # should match value of above entropy function call
}
