% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metrics-generics.R
\name{contrast}
\alias{contrast}
\alias{contrast.default}
\alias{contrast.matrix}
\alias{contrast.FitLandDF}
\title{Contrast Metric for a GLCM}
\usage{
contrast(x, ...)

\method{contrast}{default}(x, ...)

\method{contrast}{matrix}(x, ...)

\method{contrast}{FitLandDF}(x, nlevels, ...)
}
\arguments{
\item{x}{gray-level co-occurrence matrix}

\item{...}{additional parameters}

\item{nlevels}{desired number of discrete gray levels}
}
\value{
double
}
\description{
Calculate the contrast feature or metric for a gray-level co-occurrence
matrix. For definition and application, see Lofstedt et al. (2019)
\doi{10.1371/journal.pone.0212110}.
}
\examples{
## calculate contrast of arbitrary GLCM
# define arbitrary GLCM
x <- matrix(1:16, nrow = 4)

# normalize
n_x <- normalize_glcm(x)

# calculate contrast
contrast(n_x)

# calculate contrast of fitness landscape, assuming 2 discrete gray levels
vals <- runif(64)
vals <- array(vals, dim = rep(4, 3))
my_landscape <- fitscape::FitLandDF(vals)

my_glcm <- get_comatrix(my_landscape, discrete = equal_discrete(2))
contrast(my_landscape, nlevels = 2)

## confirm value of contrast for fitness landscape
# extract normalized GLCM from fitness landscape

contrast(my_glcm)  # should match value of above contrast function call
}
