% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{cells_row_groups}
\alias{cells_row_groups}
\title{Location helper for targeting row groups}
\usage{
cells_row_groups(groups = everything())
}
\arguments{
\item{groups}{\emph{Specification of row group IDs}

\verb{<row-group-targeting expression>} // \emph{default:} \code{everything()}

The row groups to which targeting operations are constrained. Can either be
a series of row group ID values provided in \code{c()} or a select helper
function (e.g. \code{\link[=starts_with]{starts_with()}}, \code{\link[=ends_with]{ends_with()}}, \code{\link[=contains]{contains()}}, \code{\link[=matches]{matches()}},
\code{\link[=num_range]{num_range()}}, and \code{\link[=everything]{everything()}}).}
}
\value{
A list object with the classes \code{cells_row_groups} and
\code{location_cells}.
}
\description{
\code{cells_row_groups()} is used to target the table's row groups
when applying a footnote with \code{\link[=tab_footnote]{tab_footnote()}} or adding custom style with
\code{\link[=tab_style]{tab_style()}}. The function is expressly used in each of those functions'
\code{locations} argument. The 'row_groups' location can be generated by the
specifying a \code{groupname_col} in \code{\link[=gt]{gt()}}, by introducing grouped data to \code{\link[=gt]{gt()}}
(via \code{\link[dplyr:group_by]{dplyr::group_by()}}), or, by specifying groups with \code{\link[=tab_row_group]{tab_row_group()}}.
}
\section{Targeting cells with \code{groups}}{


By default \code{groups} is set to \code{everything()}, which means that all available
groups will be considered. Providing the ID values (in quotes) of row groups
in \code{c()} will serve to constrain the targeting to that subset of groups.
}

\section{Examples}{


Let's use a summarized version of the \code{\link{pizzaplace}} dataset to create a
\strong{gt} table with grouped data. Add a summary with \code{\link[=summary_rows]{summary_rows()}} and then
add a footnote to the \code{"peppr_salami"} row group label with \code{\link[=tab_footnote]{tab_footnote()}};
the targeting is done with \code{cells_row_groups()} in the \code{locations} argument.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{pizzaplace |>
  dplyr::filter(name \%in\% c("soppressata", "peppr_salami")) |>
  dplyr::group_by(name, size) |>
  dplyr::summarize(`Pizzas Sold` = dplyr::n(), .groups = "drop") |>
  gt(rowname_col = "size", groupname_col = "name") |>
  summary_rows(
    columns = `Pizzas Sold`,
    fns = list(label = "TOTAL", fn = "sum"),
    fmt = ~ fmt_integer(.)
  ) |>
  tab_footnote(
    footnote = "The Pepper-Salami.",
    cells_row_groups(groups = "peppr_salami")
  )
}\if{html}{\out{</div>}}

\if{html}{\out{
<img src="https://raw.githubusercontent.com/rstudio/gt/master/images/man_cells_row_groups_1.png" alt="This image of a table was generated from the first code example in the `cells_row_groups()` help file." style="width:100\%;">
}}
}

\section{Function ID}{

8-16
}

\section{Function Introduced}{

\code{v0.2.0.5} (March 31, 2020)
}

\seealso{
Other location helper functions: 
\code{\link{cells_body}()},
\code{\link{cells_column_labels}()},
\code{\link{cells_column_spanners}()},
\code{\link{cells_footnotes}()},
\code{\link{cells_grand_summary}()},
\code{\link{cells_source_notes}()},
\code{\link{cells_stub}()},
\code{\link{cells_stub_grand_summary}()},
\code{\link{cells_stub_summary}()},
\code{\link{cells_stubhead}()},
\code{\link{cells_summary}()},
\code{\link{cells_title}()},
\code{\link{location-helper}}
}
\concept{location helper functions}
