% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{gr_plot_periods}
\alias{gr_plot_periods}
\title{Plot long-term hydrograph variable changes}
\usage{
gr_plot_periods(
  df,
  ...,
  year = NULL,
  exclude = NULL,
  tests = NULL,
  layout = as.matrix(1),
  pagebreak = FALSE,
  print = TRUE
)
}
\arguments{
\item{df}{\code{data.frame} of hydrograph and meteorological variables produced by \code{\link[=gr_summarize]{gr_summarize()}}.}

\item{...}{Quoted sequence of variable names.}

\item{year}{Integer. Change year value to separate two periods (overridden by tests if it is supplied).}

\item{exclude}{Integer vector of years to be excluded from plotting.}

\item{tests}{Tests list for the same variables (generated by \code{\link[=gr_test_vars]{gr_test_vars()}} function)}

\item{layout}{\code{matrix} that encodes the order of plotting.}

\item{pagebreak}{Logical. Whether to break page between plots (needed for reporting). Defaults to \code{FALSE}.}

\item{print}{Boolean. Print plot? Defaults to \code{TRUE}. Use \code{FALSE} if you want to tweak the plot aesthetics before plotting.}
}
\value{
\code{list} of \code{ggplot2}  objects, one for each variable, representing its long-term changes
}
\description{
This function generates boxplots of the hydrograph separation variables produced by \code{\link[=gr_summarize]{gr_summarize()}}. The data for each variable is divided into two samples: before and after the change year either set by \code{year} parameter or extracted from \code{tests} (statistically estimated). Different background fill colors are used to differentiate seasons types.
}
\examples{
library(grwat)

data(spas) # example Spas-Zagorye data is included with grwat package

# separate
sep = gr_separate(spas, params = gr_get_params(reg = 'center'))

# summarize from 1965 to 1990
vars = gr_summarize(sep, 1965, 1990)

# plot periods with fixed change year
gr_plot_periods(vars, Qygr, year = 1978)

# plot periods with change year from Pettitt test
gr_plot_periods(vars, Qygr, tests = TRUE)

# calculate test beforehand
tests = gr_test_vars(vars)
gr_plot_periods(vars, Qspmax, tests = tests)

# use matrix layout to plot multiple variables
gr_plot_periods(vars, Qygr, Qspmax, D10w1, Wsprngr,
                layout = matrix(1:4, nrow = 2),
                tests = tests)
}
