% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gridify-methods.R
\name{show_cells}
\alias{show_cells}
\alias{show_cells,gridifyClass-method}
\alias{show_cells,gridifyLayout-method}
\title{Show the cells in a gridify object or layout}
\usage{
show_cells(object)

\S4method{show_cells}{gridifyClass}(object)

\S4method{show_cells}{gridifyLayout}(object)
}
\arguments{
\item{object}{A gridifyClass or gridifyLayout object.}
}
\value{
A print out of the available cells and for gridifyClass indicates whether each cell is filled or empty.
}
\description{
Method for showing the cells of a gridifyClass or gridifyLayout object.
It prints the names of the cells and for gridifyClass it indicates whether each cell is filled or empty.
}
\examples{
show_cells(complex_layout())

# (to use |> version 4.1.0 of R is required, for lower versions we recommend \%>\% from magrittr)
library(magrittr)

g <- gridify(
  object = ggplot2::ggplot(data = mtcars, ggplot2::aes(x = mpg, y = wt)) +
    ggplot2::geom_line(),
  layout = simple_layout()
) \%>\%
  set_cell("title", "TITLE")

show_cells(g)

g <- gridify(
  object = ggplot2::ggplot(data = mtcars, ggplot2::aes(x = mpg, y = wt)) +
    ggplot2::geom_line(),
  layout = complex_layout()
) \%>\%
  set_cell("header_left", "Left Header") \%>\%
  set_cell("header_right", "Right Header") \%>\%
  set_cell("title", "Title") \%>\%
  set_cell("note", "Note") \%>\%
  set_cell("footer_left", "Left Footer") \%>\%
  set_cell("footer_right", "Right Footer")

show_cells(g)
}
