% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gridify-methods.R
\name{export_to}
\alias{export_to}
\alias{export_to,gridifyClass-method}
\alias{export_to,list-method}
\alias{export_to,ANY-method}
\title{Export gridify objects to a file}
\usage{
export_to(x, to, device = NULL, ...)

\S4method{export_to}{gridifyClass}(x, to, device = NULL, ...)

\S4method{export_to}{list}(x, to, device = NULL, ...)

\S4method{export_to}{ANY}(x, to, device = NULL, ...)
}
\arguments{
\item{x}{A \code{gridifyClass} object or a list of \code{gridifyClass} objects.}

\item{to}{A character string (or vector) specifying the output file name(s).
The extension determines the output format.}

\item{device}{a function for graphics device.
By default a file name extension is used to choose a graphics device function. Default \code{NULL}}

\item{...}{Additional arguments passed to the graphics device functions
(\code{pdf()}, \code{png()}, \code{tiff()}, \code{jpeg()} or your custom one).
Default width and height for each export type, respectively:
\itemize{
\item PDF: 11.69 inches x 8.27 inches
\item PNG: 600 px x 400 px
\item TIFF: 600 px x 400 px
\item JPEG: 600 px x 400 px
}}
}
\value{
No value is returned; the function is called for its side effect of writing output to a file.
}
\description{
The \code{export_to()} function exports a \code{gridifyClass} object or a list of such objects to a specified file.
Supported formats include PDF, PNG, TIFF and JPEG.
For lists, if a single file name with a PDF file extension is provided,
the objects
are combined into a multi-page PDF; if a character vector with one file per object is provided,
each object is written to its corresponding file. It is not possible to create multi-page PNG or JPEG files.
}
\details{
For PDF export, a new device is opened, the grid is printed using the object's
custom print method, and then the device is closed.
For PNG and JPEG, the device is opened, a new grid page is started, the grid is
printed, and then the device is closed.

When exporting a list of objects:
\itemize{
\item If \code{to} is a single PDF file (length is 1), the function creates a multi-page PDF.
\item If a vector of file names (one per object) is provided, each gridify object is
written to its corresponding file.
}
}
\note{
\code{gridify} objects can be saved directly in \code{.Rmd} and \code{.Qmd} documents,
just like in the \code{gridify} package vignettes.

\strong{gt \code{pct()} issue}

Using \code{pct()} to set the width of \code{gt} tables can be unreliable when exporting to PDF. It is recommended to use
\code{px()} to set the width in pixels instead.
}
\examples{
library(gridify)
library(magrittr)
library(ggplot2)

# Create a gridify object using a ggplot and a custom layout:

# Set text elements on various cells:
gridify_obj <- gridify(
  object = ggplot2::ggplot(data = mtcars, ggplot2::aes(x = mpg, y = wt)) +
    ggplot2::geom_line(),
  layout = pharma_layout_base(
    margin = grid::unit(c(0.5, 0.5, 0.5, 0.5), "inches"),
    global_gpar = grid::gpar(fontfamily = "serif", fontsize = 10)
  )
) \%>\%
  set_cell("header_left_1", "My Company") \%>\%
  set_cell("header_left_2", "<PROJECT> / <INDICATION>") \%>\%
  set_cell("header_left_3", "<STUDY>") \%>\%
  set_cell("header_right_1", "CONFIDENTIAL") \%>\%
  set_cell("header_right_2", "<Draft or Final>") \%>\%
  set_cell("header_right_3", "Data Cut-off: YYYY-MM-DD") \%>\%
  set_cell("output_num", "<Output> xx.xx.xx") \%>\%
  set_cell("title_1", "<Title 1>") \%>\%
  set_cell("title_2", "<Title 2>") \%>\%
  set_cell("title_3", "<Optional Title 3>") \%>\%
  set_cell("by_line", "By: <GROUP>, <optionally: Demographic parameters>") \%>\%
  set_cell("note", "<Note or Footnotes>") \%>\%
  set_cell("references", "<References:>") \%>\%
  set_cell("footer_left", "Program: <PROGRAM NAME>, YYYY-MM-DD at HH:MM") \%>\%
  set_cell("footer_right", "Page xx of nn") \%>\%
  set_cell("watermark", "DRAFT")

# Export a result to different file types

# Different file export formats require specific capabilities in your R installation.
# Use capabilities() to check which formats are supported in your R build.

# PNG
temp_png_default <- tempfile(fileext = ".png")
export_to(
  gridify_obj,
  to = temp_png_default
)

temp_png_custom <- tempfile(fileext = ".png")
export_to(
  gridify_obj,
  to = temp_png_custom,
  width = 2400,
  height = 1800,
  res = 300
)

# JPEG
temp_jpeg_default <- tempfile(fileext = ".jpeg")
export_to(
  gridify_obj,
  to = temp_jpeg_default
)

temp_jpeg_custom <- tempfile(fileext = ".jpeg")
export_to(
  gridify_obj,
  to = temp_jpeg_custom,
  width = 2400,
  height = 1800,
  res = 300
)

# TIFF
temp_tiff_default <- tempfile(fileext = ".tiff")
export_to(
  gridify_obj,
  to = temp_tiff_default
)

temp_tiff_custom <- tempfile(fileext = ".tiff")
export_to(
  gridify_obj,
  to = temp_tiff_custom,
  width = 2400,
  height = 1800,
  res = 300
)

# PDF
temp_pdf_A4 <- tempfile(fileext = ".pdf")
export_to(
  gridify_obj,
  to = temp_pdf_A4
)

temp_pdf_A4long <- tempfile(fileext = ".pdf")
export_to(
  gridify_obj,
  to = temp_pdf_A4long,
  width = 8.3,
  height = 11.7
)

# Use different pdf device - cairo_pdf
temp_pdf_A4long_cairo <- tempfile(fileext = ".pdf")
export_to(
  gridify_obj,
  to = temp_pdf_A4long_cairo,
  device = grDevices::cairo_pdf,
  width = 8.3,
  height = 11.7
)

# Multiple Objects - a list

gridify_list <- list(gridify_obj, gridify_obj)

temp_pdf_multipageA4 <- tempfile(fileext = ".pdf")
export_to(
  gridify_list,
  to = temp_pdf_multipageA4
)

temp_pdf_multipageA4long <- tempfile(fileext = ".pdf")
export_to(
  gridify_list,
  to = temp_pdf_multipageA4long,
  width = 8.3,
  height = 11.7
)

temp_png_multi <- c(tempfile(fileext = ".png"), tempfile(fileext = ".png"))
export_to(
  gridify_list,
  to = temp_png_multi
)

temp_png_multi_custom <- c(tempfile(fileext = ".png"), tempfile(fileext = ".png"))
export_to(
  gridify_list,
  to = temp_png_multi_custom,
  width = 800,
  height = 600,
  res = 96
)

}
