% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_gam_predict.R
\name{plot_gam_predict}
\alias{plot_gam_predict}
\title{Plot prediction of \code{gam} model}
\usage{
plot_gam_predict(
  Model,
  xcol,
  ycol,
  ByFactor,
  symsize = 1,
  s_alpha = 0.1,
  smooth_alpha = 0.7,
  linethick,
  fontsize = 20,
  ...
)
}
\arguments{
\item{Model}{a generalised additive model (\code{gam}) fitted with \code{ga_model} or \code{mgcv}}

\item{xcol}{the smooth in the \code{gam} (should match variable in the model exactly)}

\item{ycol}{the dependent variable in \code{gam} (should match variable in the model exactly)}

\item{ByFactor}{the \code{by} factor used in \code{gam} (should match variable in the model exactly)}

\item{symsize}{size of symbols (default = 1)}

\item{s_alpha}{opacity of symbols (default = 0.1)}

\item{smooth_alpha}{opacity of the predicted CI interval (default = 0.7)}

\item{linethick}{thickness of symbol lines (default = fontsize/22)}

\item{fontsize}{base font size for graph}

\item{...}{additional arguments to pass to \code{\link{plot_xy_CatGroup}}.}
}
\value{
This function returns a \code{ggplot2} object of class "gg" and "ggplot".
}
\description{
Plot prediction of \code{gam} model
}
\examples{
#fit zooplankton data
z1 <- ga_model(data = data_zooplankton,
Y_value = "log(density_adj)",
Fixed_Factor = "taxon",
Smooth_Factor = "day")

#plot fitted data
plot_gam_predict(Model = z1,
xcol = day, 
ycol = `log(density_adj)`,
ByFactor = taxon)


}
