% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extractors.R
\name{pars}
\alias{pars}
\title{Parameter Names}
\usage{
pars(gpModel)
}
\arguments{
\item{gpModel}{object of class GPPM.}
}
\value{
The names of the parameters
}
\description{
Extracts the parameter names from a GPPM.
}
\examples{
\donttest{
data("demoLGCM")
lgcm <- gppm(
  "muI+muS*t", "varI+covIS*(t+t#)+varS*t*t#+(t==t#)*sigma",
  demoLGCM, "ID", "y"
)
parameters <- pars(lgcm)
}
}
\seealso{
Other functions to extract from a GPPM: 
\code{\link{SE}()},
\code{\link{coef.GPPM}()},
\code{\link{confint.GPPM}()},
\code{\link{covFun}()},
\code{\link{fitted.GPPM}()},
\code{\link{getData}()},
\code{\link{getIntern}()},
\code{\link{logLik.GPPM}()},
\code{\link{maxNObs}()},
\code{\link{meanFun}()},
\code{\link{nObs}()},
\code{\link{nPars}()},
\code{\link{nPers}()},
\code{\link{nPreds}()},
\code{\link{parEsts}()},
\code{\link{preds}()},
\code{\link{vcov.GPPM}()}
}
\concept{functions to extract from a GPPM}
