% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extractors.R
\name{coef.GPPM}
\alias{coef.GPPM}
\title{Point Estimates}
\usage{
\method{coef}{GPPM}(object, ...)
}
\arguments{
\item{object}{object of class GPPM. Must be fitted, that is, a result from \code{\link{fit.GPPM}}.}

\item{...}{additional arguments (currently not used).}
}
\value{
Point estimates for all parameters as a named numeric vector.
}
\description{
Extracts point estimates for all parameters from a fitted GPPM.
}
\examples{
\donttest{
data("demoLGCM")
lgcm <- gppm(
  "muI+muS*t", "varI+covIS*(t+t#)+varS*t*t#+(t==t#)*sigma",
  demoLGCM, "ID", "y"
)
lgcmFit <- fit(lgcm)
paraEsts <- coef(lgcmFit)
}
}
\seealso{
Other functions to extract from a GPPM: 
\code{\link{SE}()},
\code{\link{confint.GPPM}()},
\code{\link{covFun}()},
\code{\link{fitted.GPPM}()},
\code{\link{getData}()},
\code{\link{getIntern}()},
\code{\link{logLik.GPPM}()},
\code{\link{maxNObs}()},
\code{\link{meanFun}()},
\code{\link{nObs}()},
\code{\link{nPars}()},
\code{\link{nPers}()},
\code{\link{nPreds}()},
\code{\link{parEsts}()},
\code{\link{pars}()},
\code{\link{preds}()},
\code{\link{vcov.GPPM}()}
}
\concept{functions to extract from a GPPM}
