% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shared_drive_get.R
\name{shared_drive_get}
\alias{shared_drive_get}
\title{Get shared drives by name or id}
\usage{
shared_drive_get(name = NULL, id = NULL)
}
\arguments{
\item{name}{Character vector of names. A character vector marked with
\code{\link[=as_id]{as_id()}} is treated as if it was provided via the \code{id} argument.}

\item{id}{Character vector of shared drive ids or URLs (it is first processed
with \code{\link[=as_id]{as_id()}}). If both \code{name} and \code{id} are non-\code{NULL}, \code{id} is silently
ignored.}
}
\value{
An object of class \code{\link{dribble}}, a tibble with one row per shared drive.
}
\description{
Retrieve metadata for shared drives specified by name or id. Note that Google
Drive does NOT behave like your local file system:
\itemize{
\item You can get zero, one, or more shared drives back for each name! Shared
drive names need not be unique.
}

A shared drive supports files owned by an organization rather than an
individual user. Shared drives follow different sharing and ownership models
from a specific user's "My Drive". Shared drives are the successors to the
earlier concept of Team Drives. Learn more about \link[=shared_drives]{shared drives}.
}
\examples{
\dontrun{
shared_drive_get("my-awesome-shared-drive")
shared_drive_get(c("apple", "orange", "banana"))
shared_drive_get(as_id("KCmiHLXUk9PVA-0AJNG"))
shared_drive_get(as_id("https://drive.google.com/drive/u/0/folders/KCmiHLXUk9PVA-0AJNG"))
shared_drive_get(id = "KCmiHLXUk9PVA-0AJNG")
shared_drive_get(id = "https://drive.google.com/drive/u/0/folders/KCmiHLXUk9PVA-0AJNG")
}
}
