% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate.R
\name{simulate_gsmvar_int}
\alias{simulate_gsmvar_int}
\title{INTERNAL Simulate method for class 'gsmvar' objects}
\usage{
simulate_gsmvar_int(
  object,
  nsim = 1,
  seed = NULL,
  ...,
  init_values = NULL,
  init_regimes = 1:sum(gsmvar$model$M),
  ntimes = 1,
  drop = TRUE,
  girf_pars = NULL
)
}
\arguments{
\item{object}{an object of class \code{'gsmvar'}, typically created with \code{fitGSMVAR} or \code{GSMVAR}.}

\item{nsim}{number of observations to be simulated.}

\item{seed}{set seed for the random number generator?}

\item{...}{currently not in use.}

\item{init_values}{a size \eqn{(p\times d)} matrix specifying the initial values, where d is the number
of time series in the system. The \strong{last} row will be used as initial values for the first lag,
the second last row for second lag etc. If not specified, initial values will be drawn according to
mixture distribution specifed by the argument \code{init_regimes}.}

\item{init_regimes}{a numeric vector of length at most \eqn{M} and elements
in \eqn{1,...,M} specifying the regimes from which the initial values
should be generated from. The initial values will be generated from a
mixture distribution with the mixture components being the stationary
distributions of the specific regimes and the (proportional) mixing weights
given by the mixing weight parameters of those regimes. Note that if
\code{init_regimes=1:M}, the initial values are generated from the
stationary distribution of the process and if \code{init_regimes=m}, the
initial value are generated from the stationary distribution of the
\eqn{m}th regime. Ignored if the argument \code{init_values} is specified.}

\item{ntimes}{how many sets of simulations should be performed?}

\item{drop}{if \code{TRUE} (default) then the components of the returned list are coerced to lower dimension if \code{ntimes==1}, i.e.,
\code{$sample} and \code{$mixing_weights} will be matrices, and \code{$component} will be vector.}

\item{girf_pars}{This argument is used internally in the estimation of generalized impulse response functions (see \code{?GIRF}).
You should ignore it (specifying something else than null to it will change how the function behaves). Should be a list with the following elements:
\describe{
  \item{\code{shock_numb}}{an integer indicating which shock to impose in the GIRF estimation.}
  \item{\code{shock_size}}{a numeric value indicating the size of the structural shock to impose in the GIRF estimation.}
  \item{\code{include_mixweights}}{a logical value indicating whether the GIRF should be estimated for the mixing weights as well.}
}}
}
\value{
If \code{drop==TRUE} and \code{ntimes==1} (default): \code{$sample}, \code{$component}, and \code{$mixing_weights} are matrices.
  Otherwise, returns a list with...
  \describe{
    \item{\code{$sample}}{a size (\code{nsim}\eqn{\times d \times}\code{ntimes}) array containing the samples: the dimension \code{[t, , ]} is
     the time index, the dimension \code{[, d, ]} indicates the marginal time series, and the dimension \code{[, , i]} indicates
     the i:th set of simulations.}
    \item{\code{$component}}{a size (\code{nsim}\eqn{\times}\code{ntimes}) matrix containing the information from which mixture component
     each value was generated from.}
    \item{\code{$mixing_weights}}{a size (\code{nsim}\eqn{\times M \times}\code{ntimes}) array containing the mixing weights corresponding to
     the sample: the dimension \code{[t, , ]} is the time index, the dimension \code{[, m, ]} indicates the regime, and the dimension
     \code{[, , i]} indicates the i:th set of simulations.}
  }
}
\description{
\code{simulate_gsmvar_int} an internal a simulation function for class 'gsmvar' objects.
  It allows to simulate observations from a GMVAR, StMVAR, or G-StMVAR process.
}
\details{
The argument \code{ntimes} is intended for forecasting: a GMVAR, StMVAR, or G-StMVAR process can be forecasted by simulating
 its possible future values. One can easily perform a large number simulations and calculate the sample quantiles from the simulated
 values to obtain prediction intervals (see the forecasting example).
}
\references{
\itemize{
   \item Kalliovirta L., Meitz M. and Saikkonen P. 2016. Gaussian mixture vector autoregression.
         \emph{Journal of Econometrics}, \strong{192}, 485-498.
   \item Lütkepohl H. 2005. New Introduction to Multiple Time Series Analysis,
         \emph{Springer}.
   \item McElroy T. 2017. Computation of vector ARMA autocovariances.
         \emph{Statistics and Probability Letters}, \strong{124}, 92-96.
   \item Virolainen S. 2025. A statistically identified structural vector autoregression with endogenously
          switching volatility regime. \emph{Journal of Business & Economic Statistics}. \strong{43}:1, 44-54.
   \item Virolainen S. in press. A Gaussian and Student’s mixture vector autoregressive model with an application
    to monetary policy shocks. Econometrics and Statistics.
 }
}
\seealso{
\code{\link{fitGSMVAR}}, \code{\link{GSMVAR}}, \code{\link{diagnostic_plot}}, \code{\link{predict.gsmvar}},
 \code{\link{profile_logliks}}, \code{\link{quantile_residual_tests}}, \code{\link{GIRF}}, \code{\link{GFEVD}}
}
\keyword{internal}
