% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gmDataFrameStack.R
\name{[.DataFrameStack}
\alias{[.DataFrameStack}
\title{Extract rows of a DataFrameStack}
\usage{
\method{[}{DataFrameStack}(x, i = NULL, j = NULL, ..., drop = FALSE)
}
\arguments{
\item{x}{\code{\link[=DataFrameStack]{DataFrameStack()}} object}

\item{i}{row indices, names or logical vector of appropriate length (i.e. typically locations, observations, etc)}

\item{j}{column indices, names or logical vector of appropriate length. DO NOT USE if you are
not sure what you are doing. The result will be a conventional data.frame, probably with the
stacking structure destroyed.}

\item{...}{generic parameters, ignored.}

\item{drop}{logical, if selection results in one single row or column selected, return a vector?}
}
\value{
the DataFrameStack or data.frame of the selected rows and columns.
}
\description{
Extract rows (and columns if you know what you are doing) from a stacked data frame
}
\examples{
ar = array(1:30, dim = c(5,2,3), dimnames=list(obs=1:5, vars=c("A","B"), rep=1:3))
dfs = DataFrameStack(ar, stackDim="rep")
dfs[1:2,]
stackDim(dfs[1:2,])
}
