% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grids.R
\name{spatialGridAcomp}
\alias{spatialGridAcomp}
\title{Construct a regionalized composition / reorder compositional simulations}
\usage{
spatialGridAcomp(coords, compo, dimcomp = 2, dimsim = NA)
}
\arguments{
\item{coords}{coordinates of the locations}

\item{compo}{(observed or predicted) compositional data set; or else array of
simulated compositions}

\item{dimcomp}{which of the dimensions of \code{compo} does correspond to the
parts of the compositon?}

\item{dimsim}{if \code{compo} contains simulations, which of its dimensions does
run across the realisations? leave it as NA if \code{compo} has observations or predictions.}
}
\value{
A (potentially transposed/aperm-ed) matrix of class  c("spatialGridAcomp","acomp")
with the coordinates in an extra attribute "coords".
}
\description{
Connect some coordinates to a composition (of hard data, of predictions
or of simulations); currently, the coordinates
are stored in an attribute and the dataset is given a complex S3 class.
This functionality \strong{will} change in the future, to make use of package
"sp" classes.
}
\seealso{
\code{\link[=image_cokriged.spatialGridAcomp]{image_cokriged.spatialGridAcomp()}} for an example; \code{\link[=gsi.gstatCokriging2compo]{gsi.gstatCokriging2compo()}} to
restructure the output from \code{\link[gstat:predict.gstat]{gstat::predict.gstat()}} confortably
}
