% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/uncorrelationTest.R
\name{spatialDecorrelation}
\alias{spatialDecorrelation}
\alias{spatialDecorrelation.gstatVariogram}
\alias{spatialDecorrelation.logratioVariogram}
\alias{spatialDecorrelation.gmEVario}
\title{Compute diagonalisation measures}
\usage{
spatialDecorrelation(vgemp, ...)

\method{spatialDecorrelation}{gstatVariogram}(
  vgemp,
  vgemp0 = NULL,
  method = "add",
  quadratic = method[1] != "rdd",
  ...
)

\method{spatialDecorrelation}{logratioVariogram}(vgemp, vgemp0 = NULL, method = "add", ...)

\method{spatialDecorrelation}{gmEVario}(vgemp, vgemp0 = NULL, method = "add", ...)
}
\arguments{
\item{vgemp}{the empirical variogram to qualify}

\item{...}{ignored}

\item{vgemp0}{optionally, a reference variogram (see below; necessary for \code{method="sde"})}

\item{method}{which quantities are desired? one or more of c("rdd", "add", "sde")}

\item{quadratic}{should the quantities be computed for a variogram or for its square? see below}
}
\value{
an object of a similar nature to \code{vgemp}, but where the desired quantities are
reported for each lag. This can then be plotted or averages be computed.
}
\description{
Compute one or more diagonalisation measures out of an empirical multivariate variogram.
}
\details{
The three measures provided are
\describe{
\item{absolute deviation from diagonality ("add")}{defined as the sum of all off-diagonal elements
of the variogram, possibly squared ($p=2$ if \code{quadratic=TRUE} the default; otherwise $p=1$)}}
\deqn{
\zeta(h)=\sum_{k=1}^n\sum_{j\neq k}^n \gamma_{k,j}^p(h)
}
\describe{
\item{relative deviation from diagonality ("rdd")}{comparing the absolute sum of off-diagonal elements
with the sum of the diagonal elements of the variogram, each possibly squared ($p=2$ if \code{quadratic=TRUE};
otherwise $p=1$ the default)}}
\deqn{
\tau(h)=\frac{\sum_{k=1}^n\sum_{j \neq k}^n |\gamma_{k,j}(h)|^p}{\sum_{k=1}^n|\gamma_{k,k}(h)|^p}
}
\describe{
\item{spatial diagonalisation efficiency ("sde")}{is the only one requiring \code{vgemp0}, because it compares
an initial state with a diagonalised state of the variogram system}}
\deqn{
\kappa(h)=1-
\frac{\sum_{k=1}^n\sum_{j \neq k}^n |\gamma_{k,j}(h)|^p}{\sum_{k=1}^n\sum_{j \neq k}^n |\gamma_{(0)k,j}(h)|^p }
}

The value of $p$ is controlled by the first value of \code{method}. That is, the results with \code{method=c("rdd", "add")}
are not the same as those obtained with \code{method=c("add", "rdd")}, as in the first case $p=1$ and in the second case $p=2$.
}
\section{Methods (by class)}{
\itemize{
\item \code{gstatVariogram}: Compute diagonalisation measures

\item \code{logratioVariogram}: Compute diagonalisation measures

\item \code{gmEVario}: Compute diagonalisation measures
}}

\examples{
data("jura", package="gstat")
X = jura.pred[, 1:2]
Z = jura.pred[,-(1:6)]
gm1 = make.gmCompositionalGaussianSpatialModel(data=Z, coords=X, V="alr")
vg1 = variogram(as.gstat(gm1)) 
(r1 = spatialDecorrelation(vg1, method=c("add", "rdd")))
plot(r1)
mean(r1)
require("compositions")
pc = princomp(acomp(Z))
v = pc$loadings
colnames(v)=paste("pc", 1:ncol(v), sep="")
gm2 = make.gmCompositionalGaussianSpatialModel(data=Z, coords=X, V=v, prefix="pc")
vg2 = variogram(as.gstat(gm2)) 
(r2 = spatialDecorrelation(vg2, method=c("add", "rdd")))
plot(r2)
mean(r2)
(r21 = spatialDecorrelation(vg2, vg1, method="sde") )
plot(r21)
mean(r21)
}
