% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gmAnisotropy.R
\name{AnisotropyScaling}
\alias{AnisotropyScaling}
\title{Convert to anisotropy scaling matrix}
\usage{
AnisotropyScaling(x)
}
\arguments{
\item{x}{an matrix to be tagged as anisotropy scaling matrix}
}
\value{
An anisotropy scaling matrix \eqn{A} is such that for any
lag vector \eqn{h}, the variogram model turns isotropic in terms
of \eqn{u'=h'\cdot A}. This function does not check any special
property for this matrix! You should probably be using \code{anis_GSLIBpar2A()}
isntead, and leave \code{AnisotropyScaling()} for internal uses.
}
\description{
Convert an anisotropy specification to a scaling matrix
}
\examples{
( l = anis_GSLIBpar2A(angles=30, ratios=0.5))
( ll = unclass(l) )
AnisotropyScaling(l)
}
\seealso{
Other anisotropy: 
\code{\link{AnisotropyRangeMatrix}()},
\code{\link{anis_GSLIBpar2A}()},
\code{\link{as.AnisotropyRangeMatrix}()},
\code{\link{as.AnisotropyScaling}()},
\code{\link{is.anisotropySpecification}()}
}
\concept{anisotropy}
